<?php
if( !function_exists('healthic_service_array') ) :
	/**
     * service array creation
     *
     * @since healthic 1.0.0
     *
     * @param  $from_service
     * @return array
     *
     */
	function healthic_service_array($from_service){
		global $healthic_customizer_all_values;

		$service_single_number_words 	= absint($healthic_customizer_all_values['healthic-service-excerpt-length']);
		$service_page_array 			= array();
		$repeated_page					= array('service-page-ids');
		$repeated_icon					= array('service-icons-ids');

		$service_post_page 	=  healthic_customizer_get_repeated_all_value(6,$repeated_page);
		$service_post_icon	=  healthic_customizer_get_repeated_all_value(6,$repeated_icon);

		$service_page_id	= array();
		if('form-category' == $from_service){
			$service_post_cat = $healthic_customizer_all_values['healthic-service-from-category'];
			if( 0 != $service_post_cat ){
				$healthic_service_arg 	= array(
					'post_type'				=> 'post',
					'cat'					=> absint($service_post_cat),
					'posts_per_page'	    => 6,
					'order'					=> 'DESC'
				); 
			}
		}
		else{
			if( null != $service_post_page) {
				foreach ( $service_post_page as $service_post_pages ){
					if( 0 != $service_post_pages['service-page-ids'] ){
						$service_page_id[]  =  $service_post_pages['service-page-ids'];
					}
				}
				if( !empty($service_page_id) ) {
					$healthic_service_arg 	= array(
						'post_type'				=> 'page',
						'post__in'				=> $service_page_id,
						'orderby'				=> 'post__in',
						'order'					=> 'ASC'
					); 
				}
			}
		}

		if( !empty($healthic_service_arg) ){
			$healthic_service_query		= new WP_Query($healthic_service_arg);
			if( $healthic_service_query->have_posts() ):
				$i = 1;
				while( $healthic_service_query->have_posts() ) :
					$healthic_service_query->the_post();
	
	                $service_page_array[] = array(
	                	'service-title'				=> get_the_title(),
	                	'service-content' 			=> has_excerpt() ? get_the_excerpt() : healthic_words_count($service_single_number_words,get_the_content() ) ,
	                	'service-url'				=> esc_url(get_the_permalink()),
	                	'service-icons-ids'			=> isset($service_post_icon[$i]['service-icons-ids']) ? $service_post_icon[$i]['service-icons-ids'] : 'fa-apple'
	                );

					$i++;
				endwhile;
				wp_reset_postdata();
			endif;
		}
		return $service_page_array;
	}
endif;


if( !function_exists('healthic_service_section') ) :
	/**
	*
	* service Section
	*
	* @since healthic 1.0.0
	*
	* @param null
	* @return null
	*
	*/
	function healthic_service_section(){
		global $healthic_customizer_all_values;

		if( 1 != $healthic_customizer_all_values['healthic-service-enable'] ){
			return null;
		}
		$healthic_service_post_selection 	= $healthic_customizer_all_values['healthic-service-select-form'];
		$healthic_service_section_title  	= $healthic_customizer_all_values['healthic-service-section-title'];
		$healthic_service_section_sub_title  = $healthic_customizer_all_values['healthic-service-section-sub-title'];
		$healthic_service_button_text  		= $healthic_customizer_all_values['healthic-service-button-text'];
		$healthic_service_button_url   		= $healthic_customizer_all_values['healthic-service-button-url'];
		$healthic_services 					= healthic_service_array( $healthic_service_post_selection );

		if( !empty( $healthic_service_section_title ) || !empty( $healthic_service_section_sub_title ) || count($healthic_services > 0 ) ) { ?>
			<!-- start services -->
    <section class="services bg-dull sp-100">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <?php if( !empty( $healthic_service_section_title ) ) {  ?>
                        <div class="all-title">
                            <h3 class="sec-title">
                                 <?php echo esc_html( $healthic_service_section_title ); ?>
                            </h3>
                            <svg class="title-sep" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <path fill-rule="evenodd" d="M84.984,12.694 L79.882,10.095 L79.882,11.932 L64.245,11.932 L61.106,8.293 L56.967,14.271 L52.820,-0.015 L50.653,15.583 L47.773,7.208 L45.062,11.932 L0.011,11.932 L0.011,13.452 L45.916,13.452 L47.432,10.819 L51.272,21.984 L53.335,7.129 L56.410,17.713 L61.235,10.749 L63.568,13.452 L79.882,13.452 L79.882,15.296 L84.984,12.694 Z"/> 
                            </svg>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <?php if( is_array( $healthic_services ) && !empty( $healthic_services ) ) { ?>
            <div class="row">
                <div class="service3-slider owl-carousel owl-theme">
                	<?php foreach( $healthic_services as $healthic_service ){ ?>
                        <div class="service-box1 mb-0">
                            <div class="service-inner">
                                <?php if( !empty( $healthic_service['service-title'] ) ) { ?>
									<h5><a href="<?php echo esc_url($healthic_service['service-url']);?>"><?php echo esc_html($healthic_service['service-title']);?></a></h5>
								<?php } ?>
                               <?php if( !empty( $healthic_service['service-content'] ) ) { ?>
									<p><?php echo wp_kses_post( $healthic_service['service-content'] ); ?></p>
								<?php } ?>
                                <a href="<?php the_permalink(); ?>" class="read-more"><?php esc_html_e('read more', 'healthic') ?></a>
                            </div>
                            <?php if( !empty( $healthic_service['service-icons-ids'] ) ) {?>
                            <div class="service-ico">
                                <i class="fa <?php echo esc_attr($healthic_service['service-icons-ids']);?>"></i>
                            </div>
                            <?php } ?>
													
                        </div>
                        <?php 
			        } ?>
                </div>
            </div>
            <?php } ?>
        </div>
    </section>
    <!-- end services -->
		<?php }
	}
endif;
add_action('healthic_homepage','healthic_service_section', 30);