<?php

if ( !function_exists('healthic_feature_slider_array') ) :
  /**
     * Featured Slider array creation
     *
     * @since healthic 1.0.0
     *
     * @param  $from_slider
     * @return array
     *
     */
    function healthic_feature_slider_array($from_slider)
    {
      global $healthic_customizer_all_values;
      $slider_excerpt_length      = absint($healthic_customizer_all_values['healthic-excerpt-length']);

      $reapeated_pages      = array('healthic-page-id');
      $feature_slider_args  = array(); 
      $feature_slideer_array = array();

      if('form-category' == $from_slider){
        $healthic_slider_cat = $healthic_customizer_all_values['healthic-select-from-cat'];
        if(0 != $healthic_slider_cat){
          $feature_slider_args = array(
                'post_type'             => 'post',
                'posts_per_page'        => 3,
                'cat'                   => absint($healthic_slider_cat),
                'ignore_sticky_posts'   => true
            );
        }
      }
      else{
        $feature_slider_post_page = healthic_customizer_get_repeated_all_value(3,$reapeated_pages);
        if (null !=$feature_slider_post_page ){
          foreach ($feature_slider_post_page as $feature_slider_post_pages){
            if ( 0 !=  $feature_slider_post_pages['healthic-page-id']){
              $feature_slider_page_ids[] = $feature_slider_post_pages['healthic-page-id'];
            }
          }
          if (!empty($feature_slider_page_ids ) ){
            $feature_slider_args = array(
              'post_type'             => 'page',
              'post__in'              => $feature_slider_page_ids,
              'order_by'              => 'post__in',
              'order'                 => 'ASC' 
            );
          }
        }
      }
      
      if( !empty( $feature_slider_args )){
          // the query
          $healthic_feature_slider_args = new WP_Query( $feature_slider_args );

          if ( $healthic_feature_slider_args->have_posts() ) :
            while ( $healthic_feature_slider_args->have_posts() ) : 
              $healthic_feature_slider_args->the_post();
                $url ='';
                if(has_post_thumbnail()){
                    $thumb = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'healthic-slider-banner-image' );
                    $url = $thumb['0'];
                }
                else {

                    $url = '';
                }

                  $feature_slideer_array[]  =  array(
                    'healthic-feature-title'    => get_the_title(),
                    'healthic-feature-content'  => has_excerpt() ? get_the_excerpt() : healthic_words_count($slider_excerpt_length, get_the_content() ),
                    'healthic-feature-image'    => esc_url( $url ),
                    'healthic-feature-url'      => esc_url( get_permalink() )

                  );
            endwhile;
            wp_reset_postdata();
          endif;
      }
      return $feature_slideer_array;

    }
endif;

if (!function_exists('healthic_feature_slider')) :
   /**
     * Featured Slider
     *
     * @since healthic 1.0.0
     *
     * @param null
     * @return null
     *
     */
 function healthic_feature_slider()
 {

  global $healthic_customizer_all_values;
  if(  !$healthic_customizer_all_values['healthic-enbale-slider'] )
  {
    return null;
  }
  $fetaure_slider_select_post        = $healthic_customizer_all_values['healthic-select-post-form'];
  $feature_slide_arrays              = healthic_feature_slider_array($fetaure_slider_select_post);
  $feature_slider_button_text        = $healthic_customizer_all_values['healthic-slider-button-text'];
  $feature_slider_button_text2       = $healthic_customizer_all_values['healthic-slider-button-text2'];
  $feature_slider_button_text2_url     = $healthic_customizer_all_values['healthic-slider-button-text2-url'];

  if ( is_array($feature_slide_arrays) ) { ?>

 <!-- main-slider -->
    <section class="main-slider">
        <div class="corp-slider theme-2  owl-carousel owl-theme">
          <?php foreach ( $feature_slide_arrays as $feature_slide_array ) {
              if( !empty( $feature_slide_array['healthic-feature-image'] ) ) {
                  $healthic_slider_image = $feature_slide_array['healthic-feature-image'];
              } else {
               $healthic_slider_image  = '';
              } ?>
              <div class="slide-item">
                <img src="<?php echo esc_url($healthic_slider_image); ?>">
                <div class="slide-overlay">
                    <div class="slide-table">
                        <div class="slide-table-cell">
                            <div class="container">
                                <div class="slide-content">
                                    <?php if( !empty( $feature_slide_array['healthic-feature-title'] ) ) { ?>
                                        <h2><?php echo esc_html( $feature_slide_array['healthic-feature-title'] ); ?></h2>
                                    <?php } ?>
                                    <?php if( !empty( $feature_slide_array['healthic-feature-content'] ) ) { ?>
                                        <p><?php echo wp_kses_post( $feature_slide_array['healthic-feature-content'] ); ?></p>
                                    <?php } ?>
                                    
                                    <?php if( !empty( $feature_slider_button_text2_url ) ) { ?>
                                        <a href="<?php echo esc_url( $feature_slider_button_text2_url ); ?>" class="btn btn-blue active"><?php echo esc_html( $feature_slider_button_text2 ); ?></a>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
              </div>
          <?php } ?>
        </div>
    </section>
    <!-- main slider ends -->

  <?php
  }
 }
endif;
add_action('healthic_homepage_slider','healthic_feature_slider',10);