<?php
if ( ! function_exists( 'healthic_set_global' ) ) :
/**
 * Setting global values for all saved customizer values
 *
 * @since healthic 1.0.0
 *
 * @param null
 * @return null
 *
 */
function healthic_set_global() {
    /*Getting saved values start*/
    $GLOBALS['healthic_customizer_all_values'] = healthic_get_all_options(1);
}
endif;
add_action( 'healthic_action_before_head', 'healthic_set_global', 0 );

if ( ! function_exists( 'healthic_doctype' ) ) :
/**
 * Doctype Declaration
 *
 * @since healthic 1.0.0
 *
 * @param null
 * @return null
 *
 */
function healthic_doctype() {
    ?>
    <!DOCTYPE html>
    <html <?php language_attributes(); ?>>
<?php
}
endif;
add_action( 'healthic_action_before_head', 'healthic_doctype', 10 );

if ( ! function_exists( 'healthic_before_wp_head' ) ) :
/**
 * Before wp head codes
 *
 * @since healthic 1.0.0
 *
 * @param null
 * @return null
 *
 */
function healthic_before_wp_head() {
    ?>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name='viewport' content='width=device-width, initial-scale=1.0, maximum-scale=1.0'/>
        <link rel="profile" href="http://gmpg.org/xfn/11">
        <?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
        <?php endif; ?>

<?php
}
endif;
add_action( 'healthic_action_before_wp_head', 'healthic_before_wp_head', 10 );

if( ! function_exists( 'healthic_default_layout' ) ) :
    /**
     * healthic default layout function
     *
     * @since  healthic 1.0.0
     *
     * @param int
     * @return string
     */
    function healthic_default_layout( $post_id = null ){

        global $healthic_customizer_all_values,$post;
        $healthic_default_layout = $healthic_customizer_all_values['healthic-default-layout'];
        if( is_home()){
            $post_id = get_option( 'page_for_posts' );
        }
        if( null == $post_id && isset ( $post->ID ) ){
            $post_id = $post->ID;
        }
        $healthic_default_layout_meta = get_post_meta( $post_id, 'healthic-default-layout', true );

        if( false != $healthic_default_layout_meta ) {
            $healthic_default_layout = $healthic_default_layout_meta;
        }
        return $healthic_default_layout;
    }
endif;

if ( ! function_exists( 'healthic_body_class' ) ) :
/**
 * add body class
 *
 * @since healthic 1.0.0
 *
 * @param null
 * @return null
 *
 */
function healthic_body_class( $healthic_body_classes ) {
  global $healthic_customizer_all_values;
  $healthic_header_background = '';
    $header_background = $healthic_customizer_all_values['healthic-header-background-enable'];

    $has_perloader = "has-preloader";
    


    $healthic_default_layout = healthic_default_layout();
    
    if( !empty( $healthic_default_layout ) ){
        if( 'left-sidebar' == $healthic_default_layout ){
            $healthic_body_classes[] = 'evt-left-sidebar'.' '. $has_perloader .' '. $healthic_header_background;
        }
        elseif( 'right-sidebar' == $healthic_default_layout ){ 
            $healthic_body_classes[] = 'evt-right-sidebar'.' '. $has_perloader .' '. $healthic_header_background;
        }
        elseif( 'both-sidebar' == $healthic_default_layout ){
            $healthic_body_classes[] = 'evt-both-sidebar'.' '. $has_perloader .' '. $healthic_header_background;
        }
        elseif( 'no-sidebar' == $healthic_default_layout ){
            $healthic_body_classes[] = 'evt-no-sidebar'.' '. $has_perloader .' '. $healthic_header_background;
        }
        
        else{
            $healthic_body_classes[] = 'evt-'. $healthic_customizer_all_values['healthic-default-layout'].' '. $has_perloader .' '. $healthic_header_background;
        }
    }
    else{
        $healthic_body_classes[] = 'evt-right-sidebar'.' '. $has_perloader .' '. $healthic_header_background;
    }
    return $healthic_body_classes;

}
endif;
add_filter( 'body_class', 'healthic_body_class', 10, 1);

if ( ! function_exists( 'healthic_before_page_start' ) ) :
/**
 * intro loader
 *
 * @since healthic 1.0.0
 *
 * @param null
 * @return null
 *
 */
function healthic_before_page_start() {
    global $healthic_customizer_all_values;
    /*intro loader*/
}
endif;
add_action( 'healthic_action_before', 'healthic_before_page_start', 10 );

if ( ! function_exists( 'healthic_page_start' ) ) :
/**
 * page start
 *
 * @since healthic 1.0.0
 *
 * @param null
 * @return null
 *
 */
function healthic_page_start() {
?>
    <div id="page" class="site clearfix">
<?php
}
endif;
add_action( 'healthic_action_before', 'healthic_page_start', 15 );

if ( ! function_exists( 'healthic_skip_to_content' ) ) :
/**
 * Skip to content
 *
 * @since healthic 1.0.0
 *
 * @param null
 * @return null
 *
 */
function healthic_skip_to_content() {
    
     global $healthic_customizer_all_values;
       
    $scroll_to_top = $healthic_customizer_all_values['healthic-enable-scroll-to-top'];
     if( 1 == $scroll_to_top) {
        ?>
            <a id="c-scroll" title="Go to top" href="javascript:void(0)">
                 <i class="fa fa-caret-up"></i>
            </a>
        <?php
        } ?>
    </div><!-- #page -->
<?php
}
endif;
add_action( 'healthic_action_before_header', 'healthic_skip_to_content', 10 );

   if ( ! function_exists( 'healthic_navigation_page_start' ) ) :
   /**
    * Skip to content
    *
    * @since healthic 1.0.0
    *
    * @param null
    * @return null
    *
    */
   function healthic_navigation_page_start() {
       global $healthic_customizer_all_values;
       ?>
        <!--  preloader -->
              <div id="preloader"></div>
        <!-- Preloader end -->

      <!-- header start-->
    <header class="theme-header header-four type-2">
        <div class="head-top head-top-four d-none d-lg-block">
            <!-- top header  -->  
            <?php 
                $top_bar_phone          = $healthic_customizer_all_values['healthic-top-bar-phone'];
                $top_bar_email          = $healthic_customizer_all_values['healthic-top-bar-email'];
                $top_bar_location       = $healthic_customizer_all_values['healthic-top-bar-location'];
                $top_bar_button         = $healthic_customizer_all_values['healthic-top-header-bar-button'];
                $top_bar_button_url     = $healthic_customizer_all_values['healthic-top-header-bar-button-url'];

                if( !empty( $top_bar_button ) ){
                    $col = 'col-4 col-md-4';
                }else{
                    $col = 'col-12 col-md-6';
                }
            ?>

            <?php if ( 1 == $healthic_customizer_all_values['healthic-enbale-top-bar-header'] ) { ?>
            <div class="container">
                <div class="row">
                    <div class="col-xl-9 col-12">
                        <?php if( !empty( $top_bar_phone ) || !empty( $top_bar_email ) || !empty( $top_bar_location )) { ?>
                          <ul class="head-con text-xl-left text-center">
                            <?php if( !empty( $top_bar_phone ) ) { ?>
                            <li>
                                <i class="fa fa-phone"></i>
                                <?php echo esc_html( $top_bar_phone ); ?>
                            </li>
                            <?php } ?>
                            <?php if( !empty( $top_bar_email ) ) { ?>
                            <li>
                                <i class="fa fa-envelope-o"></i>
                                <?php echo esc_html( $top_bar_email ); ?>
                            </li>
                            <?php } ?>
                            <?php if( !empty( $top_bar_location ) ) { ?>
                            <li>
                                <i class="fa fa-map-marker"></i>
                                <?php echo esc_html( $top_bar_location ); ?>
                            </li>
                            <?php } ?>
                          </ul>
                        <?php } ?>
                    </div>
                    <?php if( !empty( $top_bar_button_url ) ) { ?>
                    <div class="col-xl-3 col-12">
                        <div class="menu-con text-center text-xl-right">
                            <a href="<?php echo esc_url( $top_bar_button_url ); ?>" class="btn btn-blue my-2 mb-1"><?php echo esc_html($top_bar_button); ?></a>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
            <?php } ?>
        </div>
        <div class="menu menu-four affix">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-12 d-lg-block d-none">
                        <div class="logo-four logo-wrap">
                            <div class="logo my-4">

                                <?php
                                if(has_custom_logo()):
                                the_custom_logo();
                                    
                                    else:

                                        ?>
                                    <h1 class="site-title">
                                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                                            <?php bloginfo( 'name' ); ?>
                                        </a>
                                    </h1>
                                    <?php
                                $evt_description = get_bloginfo( 'description', 'display' );
                                if ( $evt_description || is_customize_preview() ) :
                                    ?>
                                    <p class="site-description"><?php echo $evt_description; /* WPCS: xss ok. */ ?></p>
                                <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-9 col-md-12">
                        <nav class="navbar navbar-expand-lg" id="nav-content">
                            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#nav-content" aria-controls="nav-content"
                                aria-expanded="false" aria-label="Toggle navigation">
                                <span class="navbar-toggler-icon bar1"></span>
                                <span class="navbar-toggler-icon bar2"></span>
                                <span class="navbar-toggler-icon bar3"></span>
                            </button>
                            <!-- Links -->
                            <div class="main-menu collapse navbar-collapse main-navigation" id="nav-content">
                                <?php
                                    wp_nav_menu( array(
                                        'theme_location'    => 'menu-1',
                                        'menu_id'           => 'menu', 
                                        'menu_class'        => 'd-md-inline-flex navbar-nav ml-auto',                            
                                        'container'         => false,
                                        'fallback_cb'       => 'healthic_primary_menu_mobile_callback',   

                                    ) );
                                ?> 
                            </div>
                        </nav>
                        <div class="mobile-menu">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- /header end-->


<div id="content" class="site-content">

<?php
}
endif;
add_action( 'healthic_action_nav_page_start', 'healthic_navigation_page_start', 10 );


if( ! function_exists( 'healthic_main_slider_setion' ) ) :
/**
 * Main slider
 *
 * @since healthic 1.0.0
 *
 * @param null
 * @return null
 *
 */
    function healthic_main_slider_setion(){
        global $healthic_customizer_all_values;

        if (  is_front_page() && !is_home() ) {
            do_action('healthic_action_main_slider');
        } else {
            /**
             * healthic_page_inner_title hook
             * @since healthic 1.0.0
             *
             * @hooked null
             */
            if(  1 ==  $healthic_customizer_all_values['healthic-slider-enable-blog'] &&  is_home() ){
                do_action('healthic_action_main_slider');
            }else{
                do_action('healthic_page_inner_title');
                do_action('healthic_action_after_title');
            }
        }
    }
endif;
add_action( 'healthic_action_on_header', 'healthic_main_slider_setion', 10 ); ?>