<?php
if ( ! function_exists( 'healthic_widget_before_footer' ) ) :
    /**
     * Footer content
     *
     * @since healthic 1.0.0
     *
     * @param null
     * @return false | void
     *
     */
    function healthic_widget_before_footer() {
        global $healthic_customizer_all_values;
        if(  !is_active_sidebar( 'footer-col-one' ) && !is_active_sidebar( 'footer-col-two' ) && !is_active_sidebar( 'footer-col-three' ) && !is_active_sidebar( 'footer-col-four' ) ){
            return false;
        }
        $col = 'col';
        ?>
         <footer class="footer footer-dark">
        <div class="foot-top">            
            <div class="container">
                <div class="row">
                     <?php if( is_active_sidebar( 'footer-col-one' ) ) : ?>
                        <div class="col-md-3 col-12">
                            <aside class="<?php echo esc_attr($col);?> footer-widget-area">
                                <?php dynamic_sidebar('footer-col-one'); ?>
                            </aside>
                        </div>
                    <?php endif; ?>

                    <?php if( is_active_sidebar( 'footer-col-two' ) ) : ?>
                        <div class="col-md-3 col-12">
                            <aside class="<?php echo esc_attr($col);?> footer-widget-area">
                                <?php dynamic_sidebar('footer-col-two'); ?>
                            </aside>
                        </div>
                    <?php endif; ?>

                    <?php if( is_active_sidebar( 'footer-col-three' ) ) : ?>
                        <div class="col-md-3 col-12">
                            <aside class="<?php echo esc_attr($col);?> footer-widget-area">
                                <?php dynamic_sidebar('footer-col-three'); ?>
                            </aside>
                        </div>
                    <?php endif; ?>

                    <?php if( is_active_sidebar( 'footer-col-four' ) ) : ?>
                        <div class="col-md-3 col-12">
                            <aside class="<?php echo esc_attr($col);?> footer-widget-area">
                                <?php dynamic_sidebar('footer-col-four'); ?>
                            </aside>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </footer>

    <?php
    }
endif;
add_action( 'healthic_action_widget_before_footer', 'healthic_widget_before_footer', 10 );

if ( ! function_exists( 'healthic_footer' ) ) :
    /**
     * Footer content
     *
     * @since healthic 1.0.0
     *
     * @param null
     * @return null
     *
     */
    function healthic_footer() {
        global $healthic_customizer_all_values;
        $healthic_theme_copyright = $healthic_customizer_all_values['healthic-copyright-text'];
        ?> 
        <!-- footer site info -->
        <div class="foot-bottom">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <?php if( !empty( $healthic_theme_copyright ) ) { ?>
                            <p>
                            <?php if(isset( $healthic_theme_copyright ) ){
                                echo wp_kses_post( $healthic_theme_copyright);
                            } 
                            ?></p>
                    <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- copyright -->   
        
        <!-- *****************************************
             Footer section ends
        ****************************************** -->
        
    <?php
    }
endif;
add_action( 'healthic_action_footer', 'healthic_footer', 10 ); 