<?php
if( !function_exists('healthic_feature_arrays') ) :
	/**
     *feature array creation
     *
     * @since healthic 1.0.0
     *
     * @param  $from_slider
     * @return array
     *
     */
	function healthic_feature_arrays($from_slider){
		global $healthic_customizer_all_values;
		$feature_number_of_word					= absint( $healthic_customizer_all_values['healthic-feature-excerpt-length'] );

		$feature_arrays	= array();
		$feature_page_id			= array();
		$reapeted_page	  				= array('feature-page-ids');
		$repeated_designation 			= array('feature-designation-ids');
		$feature_args 				= array();
		$feature_post_page 			= healthic_customizer_get_repeated_all_value(4,$reapeted_page);
		$feature_post_designation 	= healthic_customizer_get_repeated_all_value(4,$repeated_designation);

		if('form-category' == $from_slider){
			$feature_post_cat = $healthic_customizer_all_values['healthic-feature-from-category'];
			if( 0 != $feature_post_cat ){
				$feature_args 	= array(
					'post_type'				=> 'post',
					'cat'					=> absint($feature_post_cat),
					'posts_per_page'	    => 4,
					'order'					=> 'DESC'
				); 
			}
		}
		else{
			if(  null != $feature_post_page ){
				foreach($feature_post_page as $feature_post_pages){
					if( 0 != $feature_post_pages['feature-page-ids'] ){
						$feature_page_id[] = $feature_post_pages['feature-page-ids'];
					}
				}
				if( !empty($feature_page_id) ){
					$feature_args = array(
						'post_type'			=> 'page',
						'post__in'			=> $feature_page_id,
						'orderby'			=> 'post__in',
						'order'				=> 'ASC'	

					);
				}
			}
		}	
		if( !empty( $feature_args ) ){
			/*Query start*/
			$feature_ars_query 	= new WP_Query($feature_args);
			if( $feature_ars_query->have_posts()  ) :
				$i = 1;
				while( $feature_ars_query->have_posts() ) :
					$feature_ars_query->the_post();
					$th_image = false;
		            if(has_post_thumbnail()){
	                    $thumb = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
	                    $th_image = $thumb['0'];
		            }

		            $feature_arrays[] = array(
		            	'feature-title' 			=> get_the_title(),
		            	'feature-content' 			=> has_excerpt() ? get_the_excerpt() : healthic_words_count($feature_number_of_word,get_the_content() ) ,
		            	'feature-url' 				=> esc_url(get_the_permalink()),
		            	'feature-image' 			=> $th_image,
		            	'feature-designation-ids' 	=> isset( $feature_post_designation[$i]['feature-designation-ids'] ) ?  $feature_post_designation[$i]['feature-designation-ids'] : '',
		            	
		            );

		            $i++;
				endwhile;
				wp_reset_postdata();
			endif;
		}
		return $feature_arrays;	
	}
endif;

if( !function_exists('healthic_feature_section') ) :
	/**
     *feature array creation
     *
     * @since healthic 1.0.0
     *
     * @param  null
     * @return null
     */
	function healthic_feature_section(){
		global $healthic_customizer_all_values;

		if( ! $healthic_customizer_all_values['healthic-feature-enable'] ){
			return null;
		}
		$feature_select_post					= esc_html($healthic_customizer_all_values['healthic-feature-select-form'] );
		$tesimonial_pages_array						= healthic_feature_arrays($feature_select_post);		

		if( is_array($tesimonial_pages_array) )	
		{
			$feature_section_title				= esc_html($healthic_customizer_all_values['healthic-feature-section-title'] );
			
			
			?>
			<?php if(!empty($feature_section_title)  || count($tesimonial_pages_array) > 0) { ?>
				<!-- department start -->
                 <section class="bg-w sp-100-70">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12">
                                <?php if( !empty( $feature_section_title ) ) {  ?>
                                    <div class="all-title">
                                        <h3 class="sec-title">
                                             <?php echo esc_html( $feature_section_title ); ?>
                                        </h3>
                                        <svg class="title-sep" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                                        <path fill-rule="evenodd" d="M84.984,12.694 L79.882,10.095 L79.882,11.932 L64.245,11.932 L61.106,8.293 L56.967,14.271 L52.820,-0.015 L50.653,15.583 L47.773,7.208 L45.062,11.932 L0.011,11.932 L0.011,13.452 L45.916,13.452 L47.432,10.819 L51.272,21.984 L53.335,7.129 L56.410,17.713 L61.235,10.749 L63.568,13.452 L79.882,13.452 L79.882,15.296 L84.984,12.694 Z"/> 
                                        </svg>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
			            <div class="department-tab-content">
			                <div class="container">
			                     <div class="row">
			                     	<?php
										foreach ( $tesimonial_pages_array as $tesimonial_pages ){
											if( !empty( $tesimonial_pages['feature-image'] ) ){
												$feature_image 	= $tesimonial_pages['feature-image'];
											}
											$feature_image_attr_id = get_post_thumbnail_id( get_the_ID() );
											$image_attr 				= get_post_meta( $feature_image_attr_id,'_wp_attachment_image_alt',true );
											 ?>
						                        <div class="col-lg-6">
							                        <div class="tab-pane">
								                        <div class="img-wrap">
								                        	<?php if( !empty ($feature_image )) { ?>
										                    <img src="<?php echo esc_url($feature_image); ?>" alt="doctor">
										                    <?php } ?>
										                    <?php if( !empty( $tesimonial_pages['feature-title'] ) ) { ?>	
											                    <h5><?php echo esc_html( $tesimonial_pages['feature-title'] ); ?></h5>
										                    <?php } ?>
									                    </div>
									                    <?php if( !empty( $tesimonial_pages['feature-content'] ) ) { ?>	
									                     <p>
										                     <?php echo wp_kses_post( $tesimonial_pages['feature-content'] ); ?>
									                     </p>
									                     <?php } ?>
									                     <a href="<?php the_permalink(); ?>" class="btn btn-trans mt-2"><?php esc_html_e('read more', 'healthic') ?></a>
								                    </div>
							                    </div>
							          <?php } ?>

				                  </div>
					          </div>
				            </div>
                    </div>
                </section>
              <!-- department end -->
			<?php } ?>
			<!-- features-section end -->
		<?php }
	}
endif;
add_action('healthic_homepage','healthic_feature_section',70);