<?php
/**
* Returns word count of the sentences.
*
* @since healthic 1.0.0
*/
if ( ! function_exists( 'healthic_words_count' ) ) :
	function healthic_words_count( $length = 25, $healthic_content = null ) {
		$length = absint( $length );
		$more = esc_html__( '&hellip;','healthic' );
		$source_content = preg_replace( '`\[[^\]]*\]`', '', $healthic_content );
		$trimmed_content = wp_trim_words( $source_content, $length, $more );
		return $trimmed_content;
	}
endif;