<?php
/*I have added it through action so that it is flexible to the developer to adapt change*/
add_action('healthic_customizer_add_setting_control','healthic_customizer_add_setting_control_callback', 12, 5);

if ( ! function_exists( 'healthic_customizer_add_setting_control_callback' ) ) :
    /**
     * Function to add customizer setting and controls
     *
     * @access public
     * @since 1.0.0
     *
     * @param object $healthic_customizer_wp_customize
     * @param string $healthic_customizer_customizer_name common name for all setting and controls
     * @param array $healthic_customizer_basic_control_types
     * @param string $healthic_customizer_setting_control_key
     * @param array $healthic_customizer_settings_control
     * @return void
     *
     */
    function healthic_customizer_add_setting_control_callback( $healthic_customizer_wp_customize, $healthic_customizer_customizer_name, $healthic_customizer_basic_control_types, $healthic_customizer_setting_control_key, $healthic_customizer_settings_control ){
        $healthic_customizer_wp_customize->add_setting( esc_attr( $healthic_customizer_customizer_name.'['.$healthic_customizer_setting_control_key.']' ), $healthic_customizer_settings_control['setting']);

        $healthic_customizer_control_field_type = $healthic_customizer_settings_control['control']['type'];

        /*check if basic control types*/
        if ( in_array( $healthic_customizer_control_field_type, $healthic_customizer_basic_control_types ) ) {
            $healthic_customizer_wp_customize->add_control( esc_attr( $healthic_customizer_customizer_name.'['.$healthic_customizer_setting_control_key.']' ), $healthic_customizer_settings_control['control']);
        }
        else {
            /*Check for default WP_Customize_Custom_Control defined*/
            $healthic_customizer_Explode_Customize_Custom_Control_class_name = explode('_', strtolower( $healthic_customizer_control_field_type ));
            $healthic_customizer_Ucfirst_Customize_Custom_Control_class_name_array = array_map('ucfirst', $healthic_customizer_Explode_Customize_Custom_Control_class_name);
            $healthic_customizer_Implode_Customize_Custom_Control_class_name = implode('_', $healthic_customizer_Ucfirst_Customize_Custom_Control_class_name_array);

            $healthic_customizer_New_Customize_Custom_Control_class_name = 'WP_Customize_'.$healthic_customizer_Implode_Customize_Custom_Control_class_name.'_Control';
            $healthic_customizer_customizer_class_exist = false;
            if ( class_exists( $healthic_customizer_New_Customize_Custom_Control_class_name ) ) {
                $healthic_customizer_customizer_class_exist = true;
            }
            else{
                $healthic_customizer_New_Customize_Custom_Control_class_name = 'Evision_Customizer_'.$healthic_customizer_Implode_Customize_Custom_Control_class_name.'_Control';
                if ( class_exists( $healthic_customizer_New_Customize_Custom_Control_class_name ) ) {
                    $healthic_customizer_customizer_class_exist = true;
                }
            }
            if($healthic_customizer_customizer_class_exist){
                $healthic_customizer_wp_customize->add_control(
                    new $healthic_customizer_New_Customize_Custom_Control_class_name(
                        $healthic_customizer_wp_customize,
                        esc_attr( $healthic_customizer_customizer_name.'['.$healthic_customizer_setting_control_key.']'),
                        $healthic_customizer_settings_control['control']
                    )
                );
            }
            else {
                ?>

                  <script>
                    console.log('<?php echo esc_attr( $healthic_customizer_New_Customize_Custom_Control_class_name ). "not found. Please create it."?>');
                </script>

            <?php
            }

        }
    }
endif;