<?php
global $healthic_panels;
global $healthic_sections;
global $healthic_settings_controls;
global $healthic_repeated_settings_controls;
global $healthic_defaults;

// Call all default values
$healthic_defaults = healthic_defauts_value();

/*create section for service*/
$healthic_sections['healthic-service-section'] = array(
	'title'		          => esc_html__('Services Section','healthic'),
	'panel'		          => 'healthic-main-page-options',	
	'priority'	          => 70,

);

/*enable service section*/
$healthic_settings_controls['healthic-service-enable'] = array(
    'setting' =>       array(
        'default'               =>  ''
    ),
    'control' =>   array(
        'label'                 =>    esc_html__( 'Show services Section', 'healthic' ),
        'section'               =>   'healthic-service-section',
        'type'                  =>   'checkbox',
        'priority'              =>   10,
        'active_callback'       =>   ''
    )
);
    
/*Section Title*/
$healthic_settings_controls['healthic-service-section-title'] = array(
    'setting' =>       array(
        'default'              =>   $healthic_defaults['healthic-service-section-title']
    ),
    'control' =>   array(
        'label'                 =>    esc_html__( 'Section Title', 'healthic' ),
        'section'               =>   'healthic-service-section',
        'type'                  =>   'text',
        'priority'              =>   15,
        'active_callback'       =>   ''
    )
);


/*Excerpt length */
$healthic_settings_controls['healthic-service-excerpt-length'] = array(
    'setting' =>       array(
        'default'               =>   $healthic_defaults['healthic-service-excerpt-length']
    ),
    'control' =>   array(
        'label'                 =>    esc_html__( 'Excerpt Length', 'healthic' ),
        'section'               =>   'healthic-service-section',
        'type'                  =>   'number',
        'priority'              =>   30,
        'active_callback'       =>   ''
    )
);

/* Select slider post */
$healthic_settings_controls['healthic-service-select-form'] = array(
    'setting' => array(
    'default'                   => $healthic_defaults['healthic-service-select-form'] 
    ),
    'control' => array(
        'label'                 => esc_html__('Select Slider Post Type ','healthic'),
        'section'               => 'healthic-service-section',
        'type'                  => 'select',
        'choices' => array(
            'form-category'     => esc_html__('Choose From Category','healthic'),    
            'form-post'         => esc_html__('Choose From page','healthic'),    
        ),            
        'priority'              => 40,
        'acticve_callback'      => ''

    ),     
);


/*page Selection */
$healthic_repeated_settings_controls['healthic-service-from-page'] = array(
	'repeated' 		=> 6,
	'service-icons-ids' => array(
        'setting' => array(
            'default'               =>   $healthic_defaults['healthic-service-page-icon']
        ),
        'control' =>   array(
            /* translators: %s: search page icon */
            'label'                 =>    esc_html__( 'Icon for Page %s', 'healthic' ),
            /* translators: %s: search page icon describe */
            'description'           =>   sprintf( esc_html__( 'Eg: %1$s. %2$s View Font Awesome. %3$s', 'healthic' ), "<b>".'fa-wrench'."</b>",'<a href="'.esc_url('https://fontawesome.com/v4.7.0/icons/').'" target="_blank">','</a>' ),
            'section'               =>   'healthic-service-section',
            'type'                  =>   'text',
            'priority'              =>   60,
            'active_callback'       =>   ''
        )
	),
    'service-page-ids' => array(
        'setting' => array(
            'default'              =>   $healthic_defaults['healthic-service-from-page']
        ),
        'control' =>   array(
            /* translators: %s: search service page */
            'label'                 =>    esc_html__( 'Page %s', 'healthic' ),
            'section'               =>   'healthic-service-section',
            'type'                  =>   'dropdown-pages',
            'priority'              =>   60,
            'active_callback'       =>   ''
        )
    ),      
	
);