<?php
/**
 * healthic themes Theme Customizer
 *
 * @package healthic themes
 * @subpackage healthic
 * @since healthic 1.0.0
 */

/*Define Url for including css and js*/
if ( !defined( 'HEALTHIC_CUSTOMIZER_URL' ) ) {
    define( 'HEALTHIC_CUSTOMIZER_URL', trailingslashit( get_template_directory_uri() ) . 'inc/frameworks/healthic-customizer/' );
}

/*Define path for including php files*/
if ( !defined( 'HEALTHIC_CUSTOMIZER_PATH' ) ) {
    define( 'HEALTHIC_CUSTOMIZER_PATH', trailingslashit( get_template_directory() ) . 'inc/frameworks/healthic-customizer/' );
}


/*define constant for healthic customizer name*/
if(!defined('HEALTHIC_CUSTOMIZER_NAME') ){
    define( 'HEALTHIC_CUSTOMIZER_NAME', 'healthic_options' );
}

/**
 * reset options
 * @param  array $reset_options
 * @return void
 *
 * @since healthic 1.0.0
 */
if ( ! function_exists( 'healthic_reset_options' ) ) :
    function healthic_reset_options( $reset_options ) {
        set_theme_mod( HEALTHIC_CUSTOMIZER_NAME, $reset_options );
    }
endif;

require get_template_directory().'/inc/customizer/default.php';

/**
 * Customizer framework added.
 */
require get_template_directory() . '/inc/frameworks/healthic-customizer/healthic-customizer.php';
global $healthic_panels;
global $healthic_sections;
global $healthic_settings_controls;
global $healthic_repeated_settings_controls;
global $healthic_customizer_defaults;
global $healthic_defaults;

$healthic_defaults =  healthic_defauts_value();


/*mainhomepage panel*/
require get_template_directory().'/inc/customizer/main-homepage/all-option-panel.php';

/******************************************
Modify Theme Option Section Options
 *******************************************/

/*Resetting all Values*/
/**
 * Reset color settings to default
 *
 * @since healthic 1.0.0
 */
global $healthic_customizer_defaults;
$healthic_customizer_defaults['healthic-customizer-reset-settings'] = '';
if ( ! function_exists( 'healthic_customizer_reset' ) ) :
    function healthic_customizer_reset( ) {
        global $healthic_customizer_saved_values;
        $healthic_customizer_saved_values = healthic_get_all_options();
        if ( $healthic_customizer_saved_values['healthic-customizer-reset-settings'] == 1 ) {
            global $healthic_customizer_defaults;
            /*getting fields*/
            $healthic_customizer_defaults['healthic-customizer-reset-settings'] = '';
            /*resetting fields*/
            healthic_reset_options( $healthic_customizer_defaults );
        }
        else {
            return '';
        }
    }
endif;
add_action( 'customize_save_after','healthic_customizer_reset' );

$healthic_sections['healthic-customizer-reset'] = array(
        'priority'       => 999,
        'title'          => esc_html__( 'Reset All Options', 'healthic' )
);

$healthic_settings_controls['healthic-customizer-reset-settings'] = array(
    'setting' =>     array(
        'default'              => $healthic_customizer_defaults['healthic-customizer-reset-settings'],
        'transport'            => 'postmessage',
    ),
    'control' => array(
        'label'                 =>  esc_html__( 'Reset All Options', 'healthic' ),
        'description'           =>  esc_html__( 'Caution: This will reset all options to default. Publish the changes and Refresh the page to view the changes. ', 'healthic' ),
        'section'               => 'healthic-customizer-reset',
        'type'                  => 'checkbox',
        'priority'              => 10,
        'active_callback'       => ''
    )
);

/******************************************
Additional Css
 *******************************************/
$healthic_sections['custom_css'] = array(
    'title'          => esc_html__( 'Additional CSS', 'healthic' ),
    'priority'       => 400,
);

$healthic_customizer_args = array(
    'panels'            => $healthic_panels, /*always use key panels */
    'sections'          => $healthic_sections,/*always use key sections*/
    'settings_controls' => $healthic_settings_controls,/*always use key settings_controls*/
    'repeated_settings_controls' => $healthic_repeated_settings_controls,/*always use key sections*/
);

/*registering panel section setting and control start*/
function healthic_add_panels_sections_settings() {
    global $healthic_customizer_args;
    return $healthic_customizer_args;
}
add_filter( 'healthic_customizer_panels_sections_settings', 'healthic_add_panels_sections_settings' );
/*registering panel section setting and control end*/

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function healthic_customize_register( $wp_customize ) {
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
    $wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
}
add_action( 'customize_register', 'healthic_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function healthic_customize_preview_js() {
    wp_enqueue_script( 'healthic_customizer', get_template_directory_uri() . '/assets/src/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'healthic_customize_preview_js' );


/**
 * get all saved options
 * @param  null
 * @return array saved options
 *
 * @since healthic 1.0.0
 */
if ( ! function_exists( 'healthic_get_all_options' ) ) :
    function healthic_get_all_options( $merge_default = 0 ) {
        $healthic_customizer_saved_values = healthic_customizer_get_all_values( HEALTHIC_CUSTOMIZER_NAME );
        if( 1 == $merge_default ){
            global $healthic_defaults;
            if(is_array( $healthic_customizer_saved_values )){
                $healthic_customizer_saved_values = array_merge($healthic_defaults, $healthic_customizer_saved_values );
            }
            else{
                $healthic_customizer_saved_values = $healthic_defaults;
            }
        }
        return $healthic_customizer_saved_values;
    }
endif;