<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package healthic
 */

/**
 * healthic_action_before_head hook
 * @since healthic 1.0.0
 *
 * @hooked healthic_set_global -  0
 * @hooked healthic_doctype -  10
 */

do_action( 'healthic_action_before_head' );?>

<head>

	<?php
	/**
	 * healthic_action_before_wp_head hook
	 * @since healthic 1.0.0
	 *
	 * @hooked healthic_before_wp_head -  10
	 */
	do_action( 'healthic_action_before_wp_head' );

	wp_head();

	/**
	 * healthic_action_after_wp_head hook
	 * @since healthic 1.0.0
	 *
	 * @hooked null
	 */
	do_action( 'healthic_action_after_wp_head' );
	?>
</head>

<body <?php body_class(); ?>>
<?php
if ( ! function_exists( 'wp_body_open' ) ) {
function wp_body_open() {
	do_action( 'wp_body_open' );
}
} ?>

<div id="page" class="site">
<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'healthic' ); ?></a>

<?php
/**
 * healthic_action_before hook
 * @since healthic 1.0.0
 *
 * @hooked healthic_page_start - 15
 */
do_action( 'healthic_action_before' );

/**
 * healthic_action_before_header hook
 * @since healthic 1.0.0
 *
 * @hooked healthic_skip_to_content - 10
 */
do_action( 'healthic_action_before_header' );

/**
 * healthic_action_header hook
 * @since healthic 1.0.0
 *
 * @hooked healthic_after_header - 10
 */
do_action( 'healthic_action_header' );

/**
 * healthic_action_nav_page_start hook
 * @since healthic 1.0.0
 *
 * @hooked page start and navigations - 10
 */
do_action( 'healthic_action_nav_page_start' );

/**
 * healthic_action_on_header hook
 * @since healthic 1.0.0
 *
 * @hooked page start and navigations - 10
 */
do_action( 'healthic_action_on_header' );

/**
 * healthic_action_before_content hook
 * @since healthic 1.0.0
 *
 * @hooked null
 */
do_action( 'healthic_action_before_content' );

?>