<?php

/**
 * healthic functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package healthic
 */

require get_template_directory() . '/inc/init.php';

if ( ! function_exists( 'healthic_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function healthic_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on healthic, use a find and replace
		 * to change 'healthic' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'healthic', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );
		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1' 	=> esc_html__( 'Primary', 'healthic' ),
			'menu-2'  => esc_html__('Social',  'healthic'),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'healthic_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		add_editor_style( array( 'assets/src/css/editor-style.css', '' ) );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'flex-width'  => true,
			'flex-height' => true,
		) );	
	}
endif;
add_action( 'after_setup_theme', 'healthic_setup' );


/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function healthic_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'healthic_content_width', 640 );
}
add_action( 'after_setup_theme', 'healthic_content_width', 0 );


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */

/**
 * Enqueue scripts and styles.
 */
function healthic_scripts() {
	global $healthic_customizer_all_values;

	/*google font*/
	wp_enqueue_style( 'healthic-google-fonts','https://fonts.googleapis.com/css?family=Open+Sans:400,600,700|Poppins:300,400,500,600,700' );
	
	// thirdparty style file
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/src/css/bootstrap.css' );
	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/src/css/font-awesome.css' );
	wp_enqueue_style( 'jQuery-owl-carousal-css', get_template_directory_uri() . '/assets/src/css/owl.carousel.css' );
	wp_enqueue_style( 'jQuery-owl-theme-default', get_template_directory_uri() . '/assets/src/css/owl.theme.default.css' );
    wp_enqueue_style( 'animate-css', get_template_directory_uri() . '/assets/src/css/animate.css' );
	wp_enqueue_style( 'slicknav', get_template_directory_uri() . '/assets/src/css/slicknav.css' );
	wp_enqueue_style( 'healthic-header', get_template_directory_uri() . '/assets/src/css/header-slick.css' );


    //theme
	wp_enqueue_style( 'healthic-style', get_stylesheet_uri() );
	wp_add_inline_style( 'healthic-responsive-style', get_template_directory_uri() . '/assets/src/css/responsive.css' );
	

	// thirdparty assets
	wp_enqueue_script( 'jquery-bootstrap', get_template_directory_uri() . '/assets/src/js/bootstrap.js', array('jquery'), true );
	wp_enqueue_script( 'jquery-owl-carousal', get_template_directory_uri() . '/assets/src/js/owl.carousel.js', array('jquery'), true );
	wp_enqueue_script( 'slicknav', get_template_directory_uri() . '/assets/src/js/jquery.slicknav.js', array('jquery'), true );
	wp_enqueue_script( 'healthic-custom', get_template_directory_uri() . '/assets/src/js/custom.js', array('jquery'), true );
	wp_localize_script( 'healthic-main', 'customzier_values', $healthic_customizer_all_values);
	wp_enqueue_script( 'healthic-skip-link-focus-fix', get_template_directory_uri() . '/assets/src/js/skip-link-focus-fix.js', array(), true );
	


	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'healthic_scripts', 99 );


if ( ! function_exists( 'healthic_single_post_navigation' ) ) :
/**
 * Displays an optional single post navigation
 *
 *
 * Create your own gutenblog_post_navigation() function to override in a child theme.
 *
 * @since Create Magazine 1.0
 */
function healthic_single_post_navigation() {
   
    the_post_navigation( array(
    	'prev_text' => '<div class="navi prev"><span class="d-block fa fa-long-arrow-left">'.esc_html__( 'Previous','healthic' ).'</span></div>',
        'next_text' => '<div class="navi next"><span class="d-block fa fa-long-arrow-right">'.esc_html__( 'Next','healthic' ).'</span></div>'
    ) );
}
endif;
 
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/upgrade/class-customize.php';
/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

require get_template_directory(). '/inc/notice-bord.php';

new healthic_notice_bord();

if( !function_exists('healthic_primary_menu_mobile_callback') ) :
	/**
	 * Fallback menu to primary menu 
	 * 
	 * @since healthic 1.0.0
	 */

function healthic_primary_menu_mobile_callback() {
	?>
		<ul id="mobile-menu" class="d-md-inline-flex">
			<li><a href="<?php echo esc_url( home_url( '/' ) );?>"><?php esc_html_e('Home','healthic');?></a></li>
			<li><a href="<?php echo esc_url( admin_url( '/nav-menus.php' ) );?>"><?php esc_html_e('Set Primary Menu','healthic');?></a></li>
		</ul>
	<?php
}
endif;

/*breadcrum function*/
if ( ! function_exists( 'healthic_simple_breadcrumb' ) ) :

	/**
	 * Simple breadcrumb.
	 *
	 * @since 1.0.0
	 */
	function healthic_simple_breadcrumb() {

		if ( ! function_exists( 'healthic_breadcrumb_trail' ) ) {
			require_once get_template_directory() . '/assets/breadcrumbs/breadcrumbs.php';
		}

		$breadcrumb_args = array(
			'container'   => 'div',
			'show_browse' => false,
		);
		healthic_breadcrumb_trail( $breadcrumb_args );

	}

endif;

// theme name
if ( ! function_exists ( 'healthic_theme_name' ) ) {
	function healthic_theme_name() {
		return esc_html__(' healthic','healthic');
	}
}

// customize the catgory title author
function healthic_customizer_remove_defualt_cat_author($title)
{
    if( is_category() ) {

        $title = single_cat_title( '', false );

    } 
    elseif ( is_tag() ) {

        $title = single_tag_title( '', false );
    }        
    else if (is_author()){
    	$title = '<span class="vcard">' . get_the_author() . '</span>' ;
    }

    return $title;

}
add_filter( 'get_the_archive_title', 'healthic_customizer_remove_defualt_cat_author' );