<?php
/**
 * The template for displaying home page.
 * @package healthic
 */
global $healthic_customizer_all_values;

get_header();
if (!is_home() && is_front_page()) {
if ( 'posts' == get_option( 'show_on_front' ) )
{
    get_template_part(( get_home_template() ) , 'healthic');
}
    else
    {
		/**
		 * healthic_homepage hook
		 * @since healthic 1.0.0
		 *
		 * @hooked healthic_homepage -  10
		 * @sub_hooked healthic_homepage - 20
         * @hooked healthic_homepage_slider -30
		 */
          
        do_action( 'healthic_homepage_slider' );
        do_action( 'healthic_homepage' );

        $healthic_static_page = absint($healthic_customizer_all_values['healthic-enable-static-page']);
        do_action('healthic_link');
        if (1 == $healthic_static_page ) { ?>
            <section class="section fp-auto-height">
                <div class="evt-img-overlay">
                    <div class="container pt-4">
                        <div class="row">
                            <div id="primary" class="content-area">
                                <main id="main" class="site-main" role="main">

                                    <?php
                                    while ( have_posts() ) : the_post();

                                        get_template_part( 'template-parts/content', 'page' );

                                        // If comments are open or we have at least one comment, load up the comment template.
                                        if ( comments_open() || get_comments_number() ) :
                                            comments_template();
                                        endif;

                                    endwhile; // End of the loop.
                                    ?>

                                </main><!-- #main -->
                            </div><!-- #primary -->
                            <?php get_sidebar(); ?>
                        </div>
                        
                    </div>
                </div>
            </section>
        <?php }
    }

}

else

{

    require_once get_template_directory() . '/index.php';
}
get_footer();